setwd("/Users/nklotz/Documents/Studium/SS2014/Masterarbeit/Daten/UCDP One-sided Violence Dataset v 1.4-2014")
load("124932_1ucdpone-sidedviolencedataset.1.4-2014.rdata")
library(ggplot2)

state <- subset(ucdpOneSided, IsGovernmentActor==1)
nsa <- subset(ucdpOneSided, IsGovernmentActor==0)

agg.state <- aggregate(state$BestFatalityEstimate, list(year=state$Year), sum)
agg.nsa <- aggregate(nsa$BestFatalityEstimate, list(year=nsa$Year), sum)

ggplot() + 
  theme_bw() + 
  geom_line(aes(x=year, y=x, group=1), agg.state) + geom_point(aes(x=year, y=x), agg.state, size=1) +
  geom_line(aes(x=year, y=x, group=1), agg.nsa, linetype="dotted", colour="red") + geom_point(aes(x=year, y=x), agg.nsa, size=1) +
  #labs("",x="",y="") + 
  ylim(c(0,15000)) +
  #annotate(geom="text", x=2009, y=12, label="Relative\nHäufigkeit\n(in %)", size=5.5, lineheight=.8) +
  #annotate(geom="text", x=2009, y=33, label="Absolute\nHäufigkeit", size=5.5, lineheight=.8) +
  theme(axis.text  = element_text(size=12))